;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Phanto Generator
;;
;; Spawns Phantos when Mario is holding the appropriate item.

!SprNum =	$00	; Sprite Number of the Phanto.

PhantoLevelList:
;;	  <Level>  <Ex1>   <ExBit>  <Count>   <Rate>
	dw $0105 : db $00 : db $00 : db $00 : db $0F
.end

;; <Level> indicates the level number.
;; <Ex1> indicates the Extra Byte 1 value to check for and spawn.
;; <Count> indicates the max number of Phantos minus 1. If 0, only spawn 1.
;; <Rate> indicates how frequently to poll for existing Phantos or generate new ones:
;; 	- $01 <- fastest (every other frame)
;; 	- $03
;; 	- $07
;; 	- $0F
;; 	- $1F
;; 	- $3F
;; 	- $7F
;; 	- $FF <- slowest (a little more than 4 seconds)


;; Generic Values, when a level doesn't exist in PhantoLevelList.
!ExtraBit = $00		; Spawn a 32X32 version? Put any value, and it'll count that's true.
!ExtraByte1 =	$00	; Extra Byte 1 setting of the Phanto to generate/check for.
!SprCount =	$01	; Max number of the spawned Phanto to allow (set to $00 for no limit).
!FireRate =	$1F	; How frequently the generator tries for a new Phanto (and spawns one if the limit has not been reached).

print "INIT ",pc
print "MAIN ",pc
	PHB
	PHK
	PLB
	JSR Main
	PLB
	RTL

Main:	PHX
;; setup parameters based on level number
	REP #$30
	LDX.w #(PhantoLevelList_end-PhantoLevelList)
	BEQ .NoTable
-	LDA $010B|!addr
	CMP PhantoLevelList,x
	BNE +
	LDA PhantoLevelList+$2,x
	STA $0C
	LDA PhantoLevelList+$3,x
	STA $0F
	LDA PhantoLevelList+$5,x
	STA $0E
	BRA .FoundLevel
+	DEX #5
	BPL -
.NoTable
	SEP #$30
	LDA.b #!ExtraByte1
	STA $0C
	LDA.b #!SprCount
	STA $0D
	LDA.b #!FireRate
	STA $0E
	LDA.b #!ExtraBit
	STA $0F
.FoundLevel
	SEP #$30
	PLX
;; run only when told to, or when sprites aren't locked/when mario is star-powered
	LDA $14
	AND $0E
	ORA $9D
	ORA $1490|!addr
	BEQ +
.NoSpawn
	RTS
;; we're checking for only alive sprites that match the specified ID
+	STZ $00
	LDY #!SprSize-1
-	PHX
	TYX
	LDA !7FAB9E,x
	PLX
	CMP.b #!SprNum
	BNE +
	PHX
	TYX
	LDA !extra_byte_1,x
	PLX
	CMP $0C
	BNE +
	LDA !14C8,y
	CMP #$08
	BNE +
	INC $00
+	DEY
	BPL -
;; we're not spawning a phanto if too many exist already
	LDA $0D
	CMP $00
	BCC .NoSpawn
;; we're not spawning a phanto if the player isn't holding the specific sprite we want them to be
	LDA $0C
	%PhantoGetCarried()
	BCC .NoSpawn
;; spawn sprite
	STZ $00
	STZ $01
	STZ $02
	STZ $03
	LDA #!SprNum
	SEC
	%SpawnSprite()
	BCS .NoSpawn
	PHX
	TYX
	LDA $0C
	STA !extra_byte_1,x
	LDA #$02
	STA !C2,x
	LDA $0F
	CMP #$01
	BPL +
	LDA !extra_bits,x
	ORA #$04
	STA !extra_bits,x
+

;; do some dumb stuff to change its position a bit
	JSL $01ACF9|!bank
	REP #$20
	AND #$007F
	SEC
	SBC #$0040
	CLC
	ADC $96
	SEP #$20
	STA !D8,x
	XBA
	STA !14D4,x

;; spawn the phanto based on the direction mario is moving if he's moving fast enough
	LDY #$00
	LDA $7B
	BMI +
	INY #2
+	CLC
	ADC #$0C
	CMP #$18
	BCS +
;; spawn the phanto at a random point if under a specific speed
	JSL $01ACF9|!bank
	AND #$01
	ASL
	TAY
+	REP #$20
	LDA $1A
	CLC
	ADC .X_Disp,y
	SEP #$20
	STA !E4,x
	XBA
	STA !14E0,x
	PLX
	RTS
.X_Disp	dw $FFE0,$0110
